local logicrunch_logo={}
local logo={image=nil,rotation=0,rotationSpeed=1.5,scaleBase=0.9,scaleAmp=0.5,scaleSpeed=6.79,x=0,y=0,width=0,height=0,visible=false,initialTimeOffset=math.pi/2}
function logicrunch_logo.load()
logo.image=love.graphics.newImage("logicrunchlogo.png")
logo.width,logo.height=logo.image:getWidth(),logo.image:getHeight()
logo.x,logo.y=1920/2,1080/2-150
end
function logicrunch_logo.update(dt,timePassed)
if timePassed>=39.6 and timePassed<54.6 then
logo.visible=true
elseif timePassed>=54.6 then
logo.visible=false
end
if logo.visible then
logo.rotation=logo.rotation+logo.rotationSpeed*dt
local currentScale=logo.scaleBase+logo.scaleAmp*math.sin((timePassed*logo.scaleSpeed)+logo.initialTimeOffset)
logo.currentScale=currentScale
end end
function logicrunch_logo.draw()
if logo.visible then
love.graphics.push()
love.graphics.translate(logo.x,logo.y)
love.graphics.rotate(logo.rotation or 0)
love.graphics.scale(logo.currentScale or 1,logo.currentScale or 1)
love.graphics.draw(logo.image,-logo.width/2,-logo.height/2)
love.graphics.pop()
end end
return logicrunch_logo
